extends CanvasLayer
class_name Gift

var _rewarded := false 

onready var _gift_anim_tree : AnimationTree = get_node(
	"tint/main/gift_main/AnimationTree")
onready var _btn_anim_tree : AnimationTree = get_node(
	"tint/main/btns_main/AnimationTree")
onready var _btn_anim : AnimationPlayer = get_node(
	"tint/main/btns_main/AnimationPlayer")
onready var _gift_anim : AnimationPlayer = get_node(
	"tint/main/gift_main/center/gift/AnimationPlayer")
	
onready var _gift_skin_texture : TextureRect = get_node(
	"tint/main/gift_main/center/gift/gift/skin")
onready var _gift_skin_glow : Control = get_node(
	"tint/main/gift_main/center/gift/gift/glow")
onready var _gift_coins_cnt : Label = get_node(
	"tint/main/gift_main/center/gift/gift/coins/reward_cnt")
onready var _gift_coins_texture : TextureRect = get_node(
	"tint/main/gift_main/center/gift/gift/coins/coins_icon")
onready var _reward_counter : TextureProgress = get_node(
	"tint/main/btns_main/open/btn_rewarded_double/open_counter")



func init(earnings : int):
	UserData.update_score(B4DFramework.get_coins_count() + earnings,
	B4DFramework.get_level())
	_show_gift()
	B4DFramework.b4d_ads.connect("rewarded",self,"_reward")
	B4DFramework.b4d_ads.connect("interstitial_closed",self,"_interstitial_closed")
	


func _show_gift() -> void:
	_gift_anim_tree.active = true
	_gift_anim_tree.set("parameters/appear/active",true)
	_btn_anim_tree.active = true
	_btn_anim_tree.set("parameters/btn_show/active",true)


func _on_open_pressed() -> void:
	Sounds.play_tap_sound()
	if _rewarded:
		get_tree().reload_current_scene()
		return
	if B4DFramework.b4d_ads.is_rewarded_video_loaded():
		B4DFramework.b4d_ads.show_rewarded_video()
	else:
		B4DFramework.pop_notif.show()
		B4DFramework.b4d_ads.load_rewarded_video()


func _on_btn_no_pressed():
	Sounds.play_tap_sound()
	if B4DFramework.b4d_ads.get_is_interstitial_loaded():
		B4DFramework.b4d_ads.show_interstitial()
	else:
		_interstitial_closed()


func _interstitial_closed() -> void:
	get_tree().reload_current_scene()


func _reward(currency , amount) -> void:
	_reward_counter.visible = false # hide counter
	_rewarded = true
	_gift_anim_tree.set("parameters/open/active",true)


func _on_gift_open():
	var cur_lvl : int = B4DFramework.get_level() 
	var is_skin_reward = ( cur_lvl / 5 ) % 2 != 0
	var random_skin : int = B4DFramework.get_rand_locked_skin()
	if is_skin_reward and random_skin > 0 :
		
		var rand_skin_texture : Texture = B4DFramework.get_skins_textures()[random_skin-1]
		_gift_skin_texture.texture = rand_skin_texture
		_gift_skin_texture.visible = true
		_gift_skin_glow.visible = true
		UserData.update_skins(random_skin,B4DFramework.get_skins_purchased() + 
			[random_skin])
	else:
		_gift_coins_texture.texture = B4DFramework.get_coin_texture()
		var reward_val := 4 * cur_lvl + randi() % 5
		_gift_coins_cnt.text = str(reward_val)
		_gift_coins_cnt.get_parent().visible = true
		UserData.update_score(B4DFramework.get_coins_count() + reward_val,
			B4DFramework.get_level())
		
	_gift_anim.play("gift_reward_show")
	_btn_anim_tree.set("parameters/btn_next/active",true)
